/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于基本数据结构接口
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 张启丰
 *      时间 : 2019.10.23
 *      内容 : 所有代码
 *************************************************************************************************/

/* exported mc_js_map */
/* exported mc_remove_json_comments */
/* exported mc_param_val_rgb_to_txt */
/* exported mc_param_val_txt_to_rgb */
/* exported mc_url_get_param */
/* exported mc_lang_update_page */

/* global $ */

/************************************************************************************************
 * 类型:
 *    map对象
 * 功能:
 *    解决IE10下不支持MAP数据对象问题
 * 参数:
 *    NA
 * 返回：
 *    NA
 * 例子：
 *    NA
 * 备注：
 *    使用方法与MAP一致
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 张启丰
 *      时间 : 2019.10.23
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_js_map() {
    var ary_keys = [];
    var obj_data = {};

    this.set = function (key, value) {
        if (0 > ary_keys.indexOf(key)) {
            ary_keys.push(key);
        }
        obj_data[key] = value;
    };
    this.get = function (key) {
        return obj_data[key];
    };
    this.get_key = function (idx) {
        if ("number" !== typeof idx) {
            return null;
        }
        if (ary_keys.length <= idx) {
            return null;
        }
        return ary_keys[idx];
    };
    this.length = function () {
        if (null === ary_keys) {
            return 0;
        }
        return ary_keys.length;
    };
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    删除json字串中的C语言样式注释
 * 参数:
 *    @param {promises<string>} str_json_txt 带注释的json字串
 * 返回：
 *    @returns {promises<string>} 删除了C语言样式注释的json字串
 * 例子：
 *    NA
 * 备注：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 张启丰
 *      时间 : 2019.10.23
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_remove_json_comments(str_json_txt) {
    if ("string" !== typeof str_json_txt || 0 === str_json_txt.length) {
        return "";
    }

    var str_ret_txt = "";
    var i_find_idx = 0;
    var i_line_end = 0;

    while (0 < str_json_txt.length) {
        i_find_idx = str_json_txt.indexOf("/*");
        if (0 > i_find_idx) {
            str_ret_txt += str_json_txt;
            break;
        }
        if (0 < i_find_idx) {
            str_ret_txt += str_json_txt.substring(0, i_find_idx);
        }

        i_find_idx = str_json_txt.indexOf("*/", i_find_idx + 2);
        if (0 > i_find_idx) {
            break;
        }

        str_json_txt = str_json_txt.substring(i_find_idx + 2);
    }

    str_json_txt = str_ret_txt;
    str_ret_txt = "";
    while (0 < str_json_txt.length) {
        i_find_idx = str_json_txt.indexOf("//");
        if (0 > i_find_idx) {
            str_ret_txt += str_json_txt;
            break;
        }
        if (0 < i_find_idx) {
            str_ret_txt += str_json_txt.substring(0, i_find_idx);
        }

        i_line_end = str_json_txt.indexOf("\r", i_find_idx + 2);
        if (0 > i_line_end) {
            i_line_end = str_json_txt.indexOf("\n", i_find_idx + 2);
            if (0 > i_line_end) {
                break;
            }
        }

        str_json_txt = str_json_txt.substring(i_line_end);
    }

    return str_ret_txt;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    将参数值RGB值格式化为整串
 * 参数:
 *    @param {promises<string>} ary_rgb_val RGB三个分量值，取前三个，若长度小于3，则不够的取第一个值
 * 返回：
 *    @returns {promises<string>} 返回 R=x,G=y,B=z 字串，如果失败则返回空
 * 例子：
 *    NA
 * 备注：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 张启丰
 *      时间 : 2019.10.23
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_param_val_rgb_to_txt(ary_rgb_val) {
    try {
        if ("object" !== typeof ary_rgb_val || 0 === ary_rgb_val.length) {
            return "";
        }

        var str_ret_val = "R=" + ary_rgb_val[0];

        if (1 < ary_rgb_val.length) {
            str_ret_val += ",G=" + ary_rgb_val[1];
        } else {
            str_ret_val += ",G=" + ary_rgb_val[0];
        }

        if (2 < ary_rgb_val.length) {
            str_ret_val += ",B=" + ary_rgb_val[2];
        } else {
            str_ret_val += ",B=" + ary_rgb_val[0];
        }

        return str_ret_val;
    } catch (err) {
        return "";
    }
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    将参数值整串转为RGB分量
 * 参数:
 *    @param {promises<string>} str_pram_val 参数值整串, R=x,G=y,B=z 字串 如果不是这种格式，则认为是一个值，将返回三个一样的分量
 * 返回：
 *    @returns {promises<Array>} 返回数组，RGB分量字串，如果失败则返回空
 * 例子：
 *    NA
 * 备注：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 张启丰
 *      时间 : 2019.10.23
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_param_val_txt_to_rgb(str_pram_val) {
    var ary_rgb_val = [];

    if ("string" !== typeof str_pram_val || 0 === str_pram_val.length) {
        return ary_rgb_val;
    }

    var i_rval_sta = str_pram_val.indexOf("R=");
    var i_rval_end = -1;

    if (0 <= i_rval_sta) {
        i_rval_sta += 2;
        i_rval_end = str_pram_val.indexOf(",", i_rval_sta);
        if (0 > i_rval_end) {
            i_rval_end = str_pram_val.length;
        }
    }

    var i_gval_sta = str_pram_val.indexOf("G=");
    var i_gval_end = -1;

    if (0 <= i_gval_sta) {
        i_gval_sta += 2;
        i_gval_end = str_pram_val.indexOf(",", i_gval_sta);
        if (0 > i_gval_end) {
            i_gval_end = str_pram_val.length;
        }
    }

    var i_bval_sta = str_pram_val.indexOf("B=");
    var i_bval_end = -1;

    if (0 <= i_bval_sta) {
        i_bval_sta += 2;
        i_bval_end = str_pram_val.indexOf(",", i_bval_sta);
        if (0 > i_bval_end) {
            i_bval_end = str_pram_val.length;
        }
    }

    if (0 <= i_rval_end && 0 <= i_gval_end && 0 <= i_bval_end) {
        ary_rgb_val.push(str_pram_val.substr(i_rval_sta, i_rval_end - i_rval_sta));
        ary_rgb_val.push(str_pram_val.substr(i_gval_sta, i_gval_end - i_gval_sta));
        ary_rgb_val.push(str_pram_val.substr(i_bval_sta, i_bval_end - i_bval_sta));
    } else {
        ary_rgb_val.push(str_pram_val);
        ary_rgb_val.push(str_pram_val);
        ary_rgb_val.push(str_pram_val);
    }

    return ary_rgb_val;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取URL参数
 * 参数:
 *    @param {promises<string>} str_param_id url中的参数名称
 * 返回：
 *    @returns {promises<string>} 返回，url中对应的参数值
 * 例子：
 *    NA
 * 备注：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 张启丰
 *      时间 : 2019.10.23
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_url_get_param(str_param_id) {
    str_param_id = str_param_id.toUpperCase();
    if ("string" !== typeof str_param_id || 0 === str_param_id.length) {
        return "";
    }

    var str_query_url = window.location.search.substring(1);
    var ary_vars = str_query_url.split("&");

    for (var idx = 0; idx < ary_vars.length; idx++) {
        var ary_pair = ary_vars[idx].split("=");

        if (ary_pair[0].toUpperCase() === str_param_id) {
            var str_param_val = ary_pair[1];

            str_param_val = str_param_val.replace(/%3A/g, ":");
            str_param_val = str_param_val.replace(/%2F/g, "/");
            str_param_val = str_param_val.replace(/%3F/g, "?");
            str_param_val = str_param_val.replace(/%3D/g, "=");
            str_param_val = str_param_val.replace(/%26/g, "&");
            str_param_val = str_param_val.replace(/%2B/g, "+");
            str_param_val = str_param_val.replace(/%20/g, " ");
            str_param_val = str_param_val.replace(/%23/g, "#");

            return str_param_val;
        }
    }
    return "";
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取URL参数
 * 参数:
 *    @param {promises<object>} obj_lang_map url语言表，ID:VAL结构
 * 返回：
 *    NA
 * 例子：
 *    NA
 * 备注：
 *    1. 根据dom标签是否存在 lang_id 属性进行刷新，通过这个属性在 obj_lang_map 中查找VAL
 *    2. 刷新时，除span外，所有标签将修改title属性为val
 *    3. 刷新时，span同时修改内部文本和title属性为val
 *    4. 控件标识：带有control_type属性
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 张启丰
 *      时间 : 2019.10.23
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_lang_update_page(obj_lang_map) {
    $("[lang_id]").each(function () {
        var str_key = $(this).attr("lang_id");

        if ("string" === typeof str_key && 0 < str_key.length) {
            var str_val = obj_lang_map[str_key.trim().toUpperCase()];

            if ("string" === typeof str_val && 0 < str_val.length) {
                if ($(this).is("span") || this.hasAttribute("control_type")) {
                    $(this).text(str_val);
                }

                $(this).attr("title", str_val);
            }
        }
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    将参数值整串转为RGB分量
 * 参数:
 *    @param {promises<Array>} ary_base_pnt 缩放基准点[X,Y]
 *    @param {promises<Array>} ary_scal_pnt 被缩放的点[X,Y]
 *    @param {promises<number>} df_scal 缩放比例
 * 返回：
 *    @returns {promises<Array>} 返回数组, 缩放后的点
 * 例子：
 *    NA
 * 备注：
 *    使用方法与MAP一致
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 张启丰
 *      时间 : 2019.10.23
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_2d_trans_scal(ary_base_pnt, ary_scal_pnt, df_scal) {
    if ("object" !== typeof ary_base_pnt || "object" !== typeof ary_scal_pnt || "number" !== typeof df_scal) {
        return [];
    }
    //缩放基准点
    var c_base_pnt_x = ary_base_pnt[0];
    var c_base_pnt_y = ary_base_pnt[1];
    //被缩放的点
    var c_scal_pnt_x = ary_scal_pnt[0];
    var c_scal_pnt_y = ary_scal_pnt[1];
    //缩放倍数
    var c_multiple_num = df_scal;
    //返回后的点 数组形式
    var ary_back_pnt = [];

    ary_back_pnt[0] = (c_scal_pnt_x - c_base_pnt_x) * c_multiple_num + c_base_pnt_x;
    ary_back_pnt[1] = (c_scal_pnt_y - c_base_pnt_y) * c_multiple_num + c_base_pnt_y;
    return ary_back_pnt;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    将参数值整串转为RGB分量
 * 参数:
 *    @param {promises<Array>} ary_base_pnt 平移基准点[X,Y]
 *    @param {promises<Array>} ary_offset_val 平移量[X,Y]
 * 返回：
 *    @returns {promises<Array>} 返回数组, 平移后的点
 * 例子：
 *    NA
 * 备注：
 *    使用方法与MAP一致
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 张启丰
 *      时间 : 2019.10.23
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_2d_trans_offset(ary_base_pnt, ary_offset_val) {
    //初始值检测
    if ("object" !== typeof ary_base_pnt || 2 !== ary_offset_val.length) {
        return [];
    }
    //基准点x,y
    var c_base_pnt_x = ary_base_pnt[0];
    var c_base_pnt_y = ary_base_pnt[1];
    //平移量 x,y
    var c_offset_x = ary_offset_val[0];
    var c_offset_y = ary_offset_val[1];
    //初始返回平移后的点
    var ary_back_pnt = [];

    //平移后的点
    ary_back_pnt[0] = c_base_pnt_x + c_offset_x;
    ary_back_pnt[1] = c_base_pnt_y + c_offset_y;
    return ary_back_pnt;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    将参数值整串转为RGB分量
 * 参数:
 *    @param {promises<Array>} ary_vec_pnt 平移基准点[X,Y]
 *    @param {promises<string>} ary_vec_dir 旋转方向
 *    @param {promises<Number>} df_angle 旋转度
 *    @param {promises<array>} ary_rotate_pnt 旋转后的点
 * 返回：
 *    @returns {promises<Array>} 返回数组, 平移后的点
 * 例子：
 *    NA
 * 备注：
 *    使用方法与MAP一致
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 张启丰
 *      时间 : 2019.10.23
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_2d_trans_rotate(ary_vec_pnt, ary_vec_dir, df_angle, ary_rotate_pnt) {
    return [];
}

